using System;

namespace Programma
{
    class A
    {
        string Standaard()
        {
            return "A: Dit is een methode met standaard zichtbaarheid en toegang";
        }

        public string Public()
        {
            return "A: Dit is een publieke methode";
        }

        protected string Protected()
        {
            return "A: Dit is een beschermde methode";
        }

        internal string Internal()
        {
            return "A: Dit is een interne methode";
        }

        private string Private()
        {
            return "A: Dit is een prive methode";
        }

        public void Test()
        {
            // test de methoden in deze klasse
            Console.WriteLine(Standaard());
            Console.WriteLine(Public());
            Console.WriteLine(Protected());
            Console.WriteLine(Internal());
            Console.WriteLine(Private());
        }

        public void TestB()
        {
            // test de methoden in klasse B. Deze klasse
            // bevindt zich in dezelfde assembly
            B b = new B();

            // Deze methode is niet zichtbaar, omdat de access modifier
            // standaard op private wordt ingesteld.
            //Console.WriteLine(b.Standaard());

            Console.WriteLine(b.Public());

            // Een protected methode kan niet buiten de eigen klasse
            // of een afgeleide klasse  worden aangeroepen.
            //Console.WriteLine(b.Protected());

            Console.WriteLine(b.Internal());

            // Een private methode kan niet buiten de eigen klasse
            // worden aangeroepen.
            //Console.WriteLine(b.Private());
        }

        public void TestC()
        {
            // test de methoden in klasse C. Deze klasse
            // bevindt zich in een andere assembly
            Bibliotheek.C c = new Bibliotheek.C();

            // Deze methode is niet zichtbaar, omdat de access modifier
            // standaard op private wordt ingesteld.
            //Console.WriteLine(c.Standaard());
            Console.WriteLine(c.Public());

            // Een protected methode kan niet buiten de eigen klasse
            // of een afgeleide klasse  worden aangeroepen.
            //Console.WriteLine(c.Protected());

            // Een internal methode kan niet buiten de eigen assembly
            // worden aangeroepen.
            //Console.WriteLine(c.Internal());

            // Een private methode kan niet buiten de eigen klasse
            // worden aangeroepen.
            //Console.WriteLine(c.Private());
        }
    }
}